// VERSION :Scilab:6.0.1
// OS : WINDOWS 10
// CAPTION:BASIC OPERATION ON CONTINUOUS TIME SIGNALS
clc ;
clear all;
close ;
//Input CT Signal
t=-2:1:2;
x=[1,1,0,1,0];
subplot (2,3,1);
plot(t,x);
xgrid(4,1,7);
xlabel("Time");
ylabel("Amplitude");
title("Input CT Signal x(t)");

//Amplitude Scaling
a=2; // Scaling factor
subplot (2,3,2);
plot(t,a*x);
xgrid(4,1,7);
xlabel("Time");
ylabel("Amplitude");
title("z(t)=2x(t)");

//Amplitude Scaling
a=0.5; // Scaling factor
subplot (2,3,3);
plot(t,a*x);
xgrid(4,1,7);
xlabel("Time");
ylabel("Amplitude");
title("z(t)=0.5x(t)");

// Time reversal
subplot (2,3,4);
plot(-t,x);
xgrid(4,1,7);
xlabel("Time");
ylabel("Amplitude");
title("z(t)=x(-t)");

//Time Shifting
subplot (2,3,5);
plot(t+2,x);
xgrid(4,1,7);
xlabel("Time");
ylabel("Amplitude");
title("z(t)=x(t+2)");

//Time Shifting
subplot (2,3,6);
plot(t-2,x);
xgrid(4,1,7);
xlabel("Time");
ylabel("Amplitude");
title("z(t)=x(t-2)");

